/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.client.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public static ForgeConfigSpec clientConfig;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableQuarryDarkmode;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableEnableQuarryDarkmodeButton;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableAreaCardCornerRendering;

    private static void init(ForgeConfigSpec.Builder clientBuilder) {
        clientBuilder.push("General");
        enableQuarryDarkmode = clientBuilder.comment("Should the quarry gui screen be rendered in Dark Mode.").define("enable_quarry_darkmode", false);
        enableEnableQuarryDarkmodeButton = clientBuilder.comment("Enable dark mode button.").define("enable_quarry_darkmode_button", true);
        enableAreaCardCornerRendering = clientBuilder.comment("Render the with Area Card selected corners in world.").define("enable_area_card_corner_rendering", true);
        clientBuilder.pop();
    }

    public static void loadConfigFile(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        ClientConfig.init(clientBuilder);
        clientConfig = clientBuilder.build();
    }
}

